#include <cvidef.h>

#ifndef _DIRECTIO_H
#define _DIRECTIO_H

#if defined(INCLUDE_AFTER_WINDOWS_H) && !defined(_INC_WINDOWS)
#error  This header must be included before utility.h and formatio.h
#error  because it includes cviauto.h which includes Windows SDK headers.
#endif /* INCLUDE_AFTER_WINDOWS_H */

#include <cviauto.h>

#ifdef __cplusplus
    extern "C" {
#endif
HRESULT CVIFUNC KDIGIOLib_NewIKDigitalIo (const char *server,

                                          int supportMultithreading, LCID locale,
                                          int reserved,
                                          CAObjHandle *objectHandle);

HRESULT CVIFUNC KDIGIOLib_OpenIKDigitalIo (const char *fileName,
                                           const char *server,
                                           int supportMultithreading,
                                           LCID locale, int reserved,
                                           CAObjHandle *objectHandle);

HRESULT CVIFUNC KDIGIOLib_ActiveIKDigitalIo (const char *server,
                                             int supportMultithreading,
                                             LCID locale, int reserved,
                                             CAObjHandle *objectHandle);

HRESULT CVIFUNC KDIGIOLib_IKDigitalIoOpenDevice (CAObjHandle objectHandle,
                                                 ERRORINFO *errorInfo,
                                                 const char *driver, long device);

HRESULT CVIFUNC KDIGIOLib_IKDigitalIoCloseDevice (CAObjHandle objectHandle,
                                                  ERRORINFO *errorInfo);

HRESULT CVIFUNC KDIGIOLib_IKDigitalIoRead (CAObjHandle objectHandle,
                                           ERRORINFO *errorInfo, short offset,
                                           unsigned char *returnValue);

HRESULT CVIFUNC KDIGIOLib_IKDigitalIoWrite (CAObjHandle objectHandle,
                                            ERRORINFO *errorInfo, short offset,
                                            unsigned char value);

HRESULT CVIFUNC KDIGIOLib_IKDigitalIoGetDriver (CAObjHandle objectHandle,
                                                ERRORINFO *errorInfo,
                                                char **returnValue);

HRESULT CVIFUNC KDIGIOLib_IKDigitalIoGetDevice (CAObjHandle objectHandle,
                                                ERRORINFO *errorInfo,
                                                long *returnValue);

HRESULT CVIFUNC KDIGIOLib_IKDigitalIoGetOpenCount (CAObjHandle objectHandle,
                                                   ERRORINFO *errorInfo,
                                                   long *returnValue);
#ifdef __cplusplus
    }
#endif
#endif /* _DIRECTIO_H */
